﻿<%@ Page Language="c#" CodePage="1200" AutoEventWireup="false" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Import Namespace="System.Linq" %>
<%@ Import Namespace="System.Collections.Generic" %>

<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.EwidencjaVat" %>



<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>

    <title>Zestawienie do deklaracji PSD-1</title>

    <style type="text/css">
        .WithSpan {
            padding-left: 7pt;
        }

        .GridCell {
            line-height: 13pt;
            font-weight: bold;
        }

        .GridCellNoBold {
            line-height: 13pt;
        }
    </style>

    <script runat="server">

        //
        // ReSharper disable UseStringInterpolation
        // ReSharper disable MergeConditionalExpression 
        // ReSharper disable ConvertPropertyToExpressionBody
        // ReSharper disable InconsistentNaming
        //


        private const decimal KwotaZwolniona = 17000000m;
        private const decimal ProgStawki2 = 170000000m;
        private static readonly Percent Stawka1 = new Percent(0.008m);
        private static readonly Percent Stawka2 = new Percent(0.014m);


        private void OnLoad(object sender, EventArgs args)
        {
            //
            // NAGŁOWEK WYDRUKU
            //

            ReportHeader1.Title = string.Format("Zestawienie do deklaracji PSD-1| Za okres: {0}", Prms.Okres);

            //
            // PODLICZENIE ELEMENTÓW VAT
            //

            var elementy = (SubTable)EwidencjaVatModule.GetInstance(Prms).EleRozliczenVATT.WgTypEwidencji[TypEwidencjiVAT.Sprzedaż];
            elementy = new SubTable(elementy, Prms.Okres)[new FieldCondition.Equal("PodlegaPSD", true)];

            var podstawa = 0m;
            var korekty = 0m;

            foreach (var elem in elementy.Cast<ElemRozliczeniaVAT>())
                if (elem.Netto.Value < 0m)
                    korekty += -elem.Netto.Value;
                else
                    podstawa += elem.Netto.Value;

            //
            // WYLICZENIE PODATKOW
            //

            var przychod = podstawa - korekty;
            var podstawaOpodatkowania = Math.Max(0m , Soneta.Tools.Math.Round( przychod - KwotaZwolniona,0));

            var podstawa1 = Math.Min(podstawaOpodatkowania, ProgStawki2);
            var podstawa2 = podstawaOpodatkowania - podstawa1;

            var podatek1 = Soneta.Tools.Math.RoundCy( podstawa1*Stawka1);
            var podatek2 = Soneta.Tools.Math.RoundCy( podstawa2*Stawka2);

            var podatekDoZaplaty = Soneta.Tools.Math.Round(podatek1 + podatek2, 0);


            //
            // PRZYGOTOWANIE WIERSZY
            //

            var rows = new List<PSDRow>();

            rows.Add(new PSDRow
            {
                Kategoria = "USTALENIE PRZYCHODU. PRZYCHÓD OSIĄGNIĘTY W DANYM MIESIĄCU (C.1.)",
                Wartosc = podstawa
            });

            rows.Add(new PSDRow
            {
                Kategoria = "KWOTA ZMNIEJSZAJĄCA PRZYCHÓD (C.2.)",
                Wartosc = korekty
            });

            rows.Add(new PSDRow
            {
                DisableBold = true,
                Kategoria = "Kwota przychodu (C.1. - C.2.)",
                Wartosc = przychod
            });

            rows.Add(new PSDRow
            {
                DisableBold = true,
                Kategoria = "Kwota zwolniona",
                Wartosc = KwotaZwolniona
            });

            rows.Add(new PSDRow
            {
                Kategoria = "PODSTAWA OPODATKOWANIA (C.3.)"
            });

            rows.Add(new PSDRow
            {
                Kategoria = "Nadwyżka przychodu ponad kwotę 17 000 000 zł.",
                Wartosc = podstawaOpodatkowania
            });

            rows.Add(new PSDRow
            {
                Stawka = Stawka1,
                Kategoria = "Podstawa opodatkowania nieprzekraczająca kwoty 170 000 000 zł.",
                Wartosc = podstawa1,
                Podatek = podatek1
            });
         
            rows.Add(new PSDRow
            {
                Stawka = Stawka2,
                Kategoria = "Podstawa opodatkowania przekraczająca kwotę 170 000 000 zł.",
                Wartosc = podstawa2,
                Podatek = podatek2
            });
      
            rows.Add(new PSDRow
            {
                Kategoria = "PODATEK DO ZAPŁATY (D.)",
                Podatek = podatekDoZaplaty
            });

            Grid1.DataSource = rows;
        }


        public class PSDRow
        {
            public bool DisableBold;

            public string Kategoria { get; set; }
            public Percent Stawka { get; set; }
            public decimal? Wartosc { get; set; }
            public decimal? Podatek { get; set; }

            public PSDRow()
            {
                Stawka = Percent.Blank;
            }
        }


        public void GridBeforeRow(object sender, RowEventArgs args)
        {
            var row = (PSDRow)args.Row;
            var cssClass = row.DisableBold ? "GridCellNoBold" : "GridCell";

            Grid1.ColumnTextCssClass = cssClass;
            ColumnCategory.CssClass = cssClass + " WithSpan";
        }


        public class Parameters : ContextBase
        {
            private FromTo _okres;

            [Caption("Za okres")]
            [DefaultWidth(16)]
            public FromTo Okres
            {
                get { return _okres; }
                set
                {
                    _okres = value.IsNull ? FromTo.Month(Date.Today) : value;
                    OnChanged();
                }
            }


            public Parameters(Context context) : base(context)
            {
                var p = (NagEwidencjiVATT.ParamsEx) context[typeof(NagEwidencjiVATT.ParamsEx)];
                _okres = p.Zakres.IsOneMonth && p.Zakres.IsFullMonth ? p.Zakres : FromTo.Month(Date.Today);
            }
        }


        [Context]
        public Parameters Prms { get; set; }

    </script>
</head>

<body>
    <form id="ZestawienieDeklaracjiPSD" method="post" runat="server">
        <ea:DataContext ID="DataContext1" runat="server" Landscape="false" OnContextLoad="OnLoad"></ea:DataContext>
        <cc1:ReportHeader ID="ReportHeader1" runat="server"></cc1:ReportHeader>
        <ea:Grid runat="server" ID="Grid1" ColumnTextCssClass="GridCell" ColumnHeaderCssClass="GridCell" OnBeforeRow="GridBeforeRow">
            <Columns>
                <ea:GridColumn runat="server" Caption="Kategoria" DataMember="Kategoria" FontSize="7pt" Width="0" ID="ColumnCategory" />
                <ea:GridColumn runat="server" Caption="Stawka podatku" DataMember="Stawka" Align="Center" Width="10" />
                <ea:GridColumn runat="server" Caption="Wartość" DataMember="Wartosc" Align="Right" Width="18" Format="{0:#,##0.00}" />
                <ea:GridColumn runat="server" Caption="Podatek" DataMember="Podatek" Align="Right" Width="18" Format="{0:#,##0.00}" />
            </Columns>
        </ea:Grid>
        <cc1:ReportFooter ID="ReportFooter1" runat="server"></cc1:ReportFooter>
    </form>
</body>
</html>
